<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AdminAuthController;
use App\Http\Controllers\Api\UserAuthController;
use App\Http\Controllers\Api\WalletController;
use App\Http\Controllers\Api\TopUpRequestController;
use App\Http\Controllers\Api\Admin\UpiController;
use App\Http\Controllers\Api\Admin\TopUpRequestController as AdminTopUpRequestController;
use App\Http\Controllers\Api\Admin\ServiceController as AdminServiceController;
use App\Http\Controllers\Api\Admin\UserController as AdminUserController;
use App\Http\Controllers\Api\Admin\RechargeOfferController as AdminRechargeOfferController;
use App\Http\Controllers\Api\Admin\ReferralController as AdminReferralController;
use App\Http\Controllers\Api\ServiceController;
use App\Http\Controllers\Api\RechargeOfferController;
use App\Http\Controllers\Api\ReferralController;
use App\Http\Controllers\Api\FarmerIdController;
use App\Http\Controllers\Api\BocwIdController;
use App\Http\Controllers\Api\SliderController;
use App\Http\Controllers\Api\Admin\SliderController as AdminSliderController;
use App\Http\Controllers\Api\OfferController;
use App\Http\Controllers\Api\Admin\OfferController as AdminOfferController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\Api\Admin\BlogController as AdminBlogController;
use App\Http\Controllers\Api\TrendingOfferController;
use App\Http\Controllers\Api\Admin\TrendingOfferController as AdminTrendingOfferController;
use App\Http\Controllers\Api\Admin\ReportController as AdminReportController;
use App\Http\Controllers\Api\Admin\GiftController as AdminGiftController;
use App\Http\Controllers\Api\GiftController;
use App\Http\Controllers\Api\TransferController;
use App\Http\Controllers\Api\PaymentController;
use App\Http\Controllers\Api\Admin\StateUrlController as AdminStateUrlController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Admin Login API
Route::post('/admin/login', [AdminAuthController::class, 'login']);

// User Signup and OTP APIs
Route::post('/user/signup', [UserAuthController::class, 'signup']);
Route::post('/user/verify-otp', [UserAuthController::class, 'verifyOtp']);
Route::post('/user/resend-otp', [UserAuthController::class, 'resendOtp']);

// CSC User Auth APIs
Route::post('/user/csc/signup', [UserAuthController::class, 'signupWithCsc']);
Route::post('/user/csc/login', [UserAuthController::class, 'loginWithCsc']);

// User Login API
Route::post('/user/login', [UserAuthController::class, 'login']);

// User Forget Password APIs
Route::post('/user/forget-password', [UserAuthController::class, 'forgetPassword']);
Route::post('/user/reset-password', [UserAuthController::class, 'resetPassword']);

// Wallet APIs
Route::post('/wallet/top-up', [WalletController::class, 'topUp']);
Route::get('/wallet/balance', [WalletController::class, 'getBalance']);

// Top-Up Request APIs (User)
Route::post('/top-up/request', [TopUpRequestController::class, 'store']);
Route::get('/top-up/requests', [TopUpRequestController::class, 'index']);
Route::get('/top-up/request/{id}', [TopUpRequestController::class, 'show']);
Route::get('/wallet/top-up/history', [TopUpRequestController::class, 'history']);

// Payment Status Check and SMS Processing APIs
Route::post('/payment/check-status', [PaymentController::class, 'checkStatus']);
Route::post('/payment/process-sms', [PaymentController::class, 'processSms']);

// Public UPI APIs (Users can view available UPIs)
Route::get('/upi/list', function() {
    $upis = \App\Models\Upi::where('status', 'active')
        ->orderBy('is_default', 'desc')
        ->orderBy('created_at', 'desc')
        ->get(['id', 'upi_id', 'name', 'is_default']);
    
    return response()->json([
        'success' => true,
        'data' => $upis
    ], 200);
});

// Admin UPI Management APIs (Requires Admin Token)
Route::prefix('admin/upi')->group(function () {
    Route::get('/', [UpiController::class, 'index']);
    Route::post('/', [UpiController::class, 'store']);
    Route::get('/{id}', [UpiController::class, 'show']);
    Route::put('/{id}', [UpiController::class, 'update']);
    Route::patch('/{id}', [UpiController::class, 'update']);
    Route::delete('/{id}', [UpiController::class, 'destroy']);
});

// Admin Top-Up Request Management APIs (Requires Admin Token)
Route::prefix('admin/top-up')->group(function () {
    Route::get('/requests', [AdminTopUpRequestController::class, 'index']);
    Route::get('/request/{id}', [AdminTopUpRequestController::class, 'show']);
    Route::post('/request/{id}/approve', [AdminTopUpRequestController::class, 'approve']);
    Route::post('/request/{id}/reject', [AdminTopUpRequestController::class, 'reject']);
});

// Service APIs (Public - for Angular frontend)
Route::get('/service/check', [ServiceController::class, 'checkByPath']);
Route::get('/service/path/{path}', [ServiceController::class, 'getByPath']);
Route::get('/services', [ServiceController::class, 'index']);

// Public Slider APIs (for Landing Page)
Route::prefix('slider')->group(function () {
    Route::get('/', [SliderController::class, 'index']);
    Route::get('/{id}', [SliderController::class, 'show']);
});

// Public Offer APIs (for Landing Page)
Route::prefix('offer')->group(function () {
    Route::get('/', [OfferController::class, 'index']);
    Route::get('/type/{type}', [OfferController::class, 'getByType']);
    Route::post('/verify-promo', [OfferController::class, 'verifyPromoCode']);
    Route::get('/{id}', [OfferController::class, 'show']);
});

// Public Blog APIs
Route::prefix('blog')->group(function () {
    Route::get('/', [BlogController::class, 'index']);
    Route::get('/latest', [BlogController::class, 'latest']);
    Route::get('/slug/{slug}', [BlogController::class, 'showBySlug']);
    Route::get('/{id}', [BlogController::class, 'show']);
});

// Public Trending Offer API (for Dashboard Scrolling Text)
Route::get('/trending-offer', [TrendingOfferController::class, 'index']);

// Admin Service Management APIs (Requires Admin Token)
Route::prefix('admin/service')->group(function () {
    Route::get('/', [AdminServiceController::class, 'index']);
    Route::get('/{id}', [AdminServiceController::class, 'show']);
    Route::post('/', [AdminServiceController::class, 'store']);
    // Update routes - POST must come before PUT to handle file uploads properly
    Route::post('/{id}', [AdminServiceController::class, 'update']); // Support POST for file uploads
    Route::put('/{id}', [AdminServiceController::class, 'update']);
    Route::patch('/{id}', [AdminServiceController::class, 'update']); // Also support PATCH
    Route::patch('/{id}', [AdminServiceController::class, 'update']);
    Route::delete('/{id}', [AdminServiceController::class, 'destroy']);
});

// Admin Slider Management APIs (Requires Admin Token)
Route::prefix('admin/slider')->group(function () {
    Route::get('/', [AdminSliderController::class, 'index']);
    Route::post('/', [AdminSliderController::class, 'store']);
    Route::get('/{id}', [AdminSliderController::class, 'show']);
    Route::put('/{id}', [AdminSliderController::class, 'update']);
    Route::patch('/{id}', [AdminSliderController::class, 'update']);
    Route::delete('/{id}', [AdminSliderController::class, 'destroy']);
});

// Admin Offer Management APIs (Requires Admin Token)
Route::prefix('admin/offer')->group(function () {
    Route::get('/', [AdminOfferController::class, 'index']);
    Route::post('/', [AdminOfferController::class, 'store']);
    Route::get('/{id}', [AdminOfferController::class, 'show']);
    Route::put('/{id}', [AdminOfferController::class, 'update']);
    Route::patch('/{id}', [AdminOfferController::class, 'update']);
    Route::delete('/{id}', [AdminOfferController::class, 'destroy']);
});

// Admin Blog Management APIs (Requires Admin Token)
Route::prefix('admin/blog')->group(function () {
    Route::get('/', [AdminBlogController::class, 'index']);
    Route::post('/', [AdminBlogController::class, 'store']);
    Route::get('/{id}', [AdminBlogController::class, 'show']);
    Route::put('/{id}', [AdminBlogController::class, 'update']);
    Route::patch('/{id}', [AdminBlogController::class, 'update']);
    Route::delete('/{id}', [AdminBlogController::class, 'destroy']);
});

// Admin Trending Offer Management APIs (Requires Admin Token)
Route::prefix('admin/trending-offer')->group(function () {
    Route::get('/', [AdminTrendingOfferController::class, 'index']);
    Route::post('/', [AdminTrendingOfferController::class, 'store']);
    Route::get('/{id}', [AdminTrendingOfferController::class, 'show']);
    Route::put('/{id}', [AdminTrendingOfferController::class, 'update']);
    Route::patch('/{id}', [AdminTrendingOfferController::class, 'update']);
    Route::delete('/{id}', [AdminTrendingOfferController::class, 'destroy']);
});

// Admin User Management APIs (Requires Admin Token)
Route::prefix('admin/user')->group(function () {
    Route::get('/csc-users', [AdminUserController::class, 'getCscUsers']);
    Route::get('/', [AdminUserController::class, 'index']);
    Route::get('/statistics', [AdminUserController::class, 'statistics']);
    Route::get('/dashboard-statistics', [AdminUserController::class, 'dashboardStatistics']);
    Route::get('/recharge-details', [AdminUserController::class, 'userRechargeDetails']);
    Route::get('/top-users', [AdminUserController::class, 'topUsersByRecharge']);
    Route::get('/{id}', [AdminUserController::class, 'show']);
    Route::put('/{id}', [AdminUserController::class, 'update']);
    Route::patch('/{id}', [AdminUserController::class, 'update']);
    Route::delete('/{id}', [AdminUserController::class, 'destroy']);
});

// Admin State URL Management APIs (Requires Admin Token)
Route::prefix('admin/state-urls')->group(function () {
    // Automation Routes (By State Name) - MUST BE BEFORE {id} routes
    Route::get('/fetch-config', [AdminStateUrlController::class, 'fetchConfig']);
    Route::post('/update-token', [AdminStateUrlController::class, 'updateToken']);

    Route::get('/', [AdminStateUrlController::class, 'index']);
    Route::post('/', [AdminStateUrlController::class, 'store']);
    Route::get('/{id}', [AdminStateUrlController::class, 'show']);
    Route::put('/{id}', [AdminStateUrlController::class, 'update']);
    Route::delete('/{id}', [AdminStateUrlController::class, 'destroy']);
    
});

// Admin Report APIs (Requires Admin Token)
Route::prefix('admin/report')->group(function () {
    Route::get('/recharge', [AdminReportController::class, 'userRechargeReport']);
    Route::get('/service', [AdminReportController::class, 'userServiceReport']);
    Route::get('/referral', [AdminReportController::class, 'referralReport']);
    Route::get('/referral/user/{userId}', [AdminReportController::class, 'userReferralReport']);
    Route::get('/user/{userId}', [AdminReportController::class, 'userCompleteReport']);
});

// Admin Gift APIs (Requires Admin Token)
Route::prefix('admin/gift')->group(function () {
    Route::post('/credit', [AdminGiftController::class, 'creditGift']);
    Route::get('/', [AdminGiftController::class, 'index']);
});

// User Gift APIs (Requires User Token)
Route::prefix('gift')->group(function () {
    Route::get('/unread', [GiftController::class, 'getUnreadGifts']);
    Route::post('/{giftId}/read', [GiftController::class, 'markAsRead']);
    Route::post('/mark-all-read', [GiftController::class, 'markAllAsRead']);
    Route::get('/', [GiftController::class, 'index']);
});

// Money Transfer APIs (Requires Distributor Token)
Route::prefix('transfer')->group(function () {
    Route::get('/search-users', [TransferController::class, 'searchUsers']);
    Route::post('/', [TransferController::class, 'transfer']);
    Route::get('/history', [TransferController::class, 'history']);
});

// Public Recharge Offer APIs
Route::prefix('recharge-offer')->group(function () {
    Route::get('/', [RechargeOfferController::class, 'index']);
    Route::get('/applicable', [RechargeOfferController::class, 'getApplicableOffers']);
    Route::get('/{id}', [RechargeOfferController::class, 'show']);
});

// Admin Recharge Offer Management APIs (Requires Admin Token)
Route::prefix('admin/recharge-offer')->group(function () {
    Route::get('/', [AdminRechargeOfferController::class, 'index']);
    Route::post('/', [AdminRechargeOfferController::class, 'store']);
    Route::get('/{id}', [AdminRechargeOfferController::class, 'show']);
    Route::put('/{id}', [AdminRechargeOfferController::class, 'update']);
    Route::patch('/{id}', [AdminRechargeOfferController::class, 'update']);
    Route::delete('/{id}', [AdminRechargeOfferController::class, 'destroy']);
});

// Public Referral APIs
Route::prefix('referral')->group(function () {
    Route::get('/code', [ReferralController::class, 'getReferralCode']);
    Route::get('/downline', [ReferralController::class, 'getDownline']);
    Route::get('/earnings', [ReferralController::class, 'getEarnings']);
    Route::post('/credit-earnings', [ReferralController::class, 'creditEarnings']);
});

// Admin Referral Management APIs (Requires Admin Token)
Route::prefix('admin/referral')->group(function () {
    Route::get('/settings', [AdminReferralController::class, 'getSettings']);
    Route::post('/settings', [AdminReferralController::class, 'updateSettings']);
    Route::put('/settings', [AdminReferralController::class, 'updateSettings']);
    Route::get('/statistics', [AdminReferralController::class, 'getStatistics']);
});

// Farmer ID Service API (Requires User Authentication)
Route::prefix('service/farmer-id')->group(function () {
    Route::post('/verify', [FarmerIdController::class, 'verify']);
    Route::get('/history', [FarmerIdController::class, 'history']);
    Route::get('/status/{id}', [FarmerIdController::class, 'getStatus']);
});

// BOCW ID Service API (Requires User Authentication)
Route::prefix('service/bocw-id')->group(function () {
    Route::post('/verify', [BocwIdController::class, 'verify']);
    Route::get('/history', [BocwIdController::class, 'history']);
    Route::get('/status/{id}', [BocwIdController::class, 'getStatus']);
});
