# Farmer ID Service API Documentation

## Overview

The Farmer ID Service API allows users to verify their Farmer ID using their Aadhar number. The service:
- Accepts Aadhar number (12 digits)
- Calls external API to verify Farmer ID
- Deducts service cost (₹25 by default, configurable by admin) from user's wallet
- Returns farmer details including Farmer ID, name, address, land ownership, etc.
- Tracks all service transactions

**Base URL:** `https://api.alldigtalseva.com/api`

---

## Table of Contents

1. [Verify Farmer ID](#verify-farmer-id)
2. [Check Transaction Status](#check-transaction-status)
3. [Service Transaction History](#service-transaction-history)
4. [Admin Service Management (with Cost)](#admin-service-management-with-cost)
5. [Error Responses](#error-responses)
6. [Testing Examples](#testing-examples)

---

## Verify Farmer ID

Verify Farmer ID using Aadhar number. This will deduct the service cost from user's wallet.

**⚠️ Important:** This API may take 1-2 minutes to respond as it calls an external API that processes the request. The timeout is set to 3 minutes. Please keep the connection open and wait for the response.

**Endpoint:** `POST /service/farmer-id/verify`

**Headers:**
```
Authorization: Bearer {user_token}
Content-Type: application/json
```

**Request Body:**
```json
{
    "aadhar": "576109808884"
}
```

**Parameters:**
- `aadhar` (required): String, exactly 12 digits. Aadhar number to verify.

**Note:** The response includes a `transaction_id` which you can use to check the status later using the status endpoint if needed.

**Success Response (200):**
```json
{
    "success": true,
    "message": "Farmer ID verified successfully",
    "data": {
        "farmer_id": "45874742709",
        "farmer_aadhar_number": "576109808884",
        "farmer_dob": "1979-08-05",
        "farmer_name_en": "Bhausaheb Sakharam Dake",
        "farmer_name_local": "भाऊसाहेब सखाराम डाके",
        "farmer_gender": "Male",
        "farmer_pincode": 431130,
        "farmer_address": "Mhalas Pimpalgav",
        "farmer_mobile": "9445760262",
        "farmer_photograph": "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",
        "farmer_land_ownerships": [
            {
                "extentAssignedAreaInHectare": 1.99,
                "villageName": "Mhalas Pimpalgaon",
                "districtName": "BEED",
                "subDistrictName": "Georai",
                "surveyNumber": "75"
            },
            {
                "extentAssignedAreaInHectare": 1.99,
                "villageName": "Mhalas Pimpalgaon",
                "districtName": "BEED",
                "subDistrictName": "Georai",
                "surveyNumber": "1"
            }
        ],
        "amount_deducted": 25.00,
        "remaining_balance": 475.00,
        "transaction_id": 1
    }
}
```

**Note:** The API response time is typically 1-2 minutes. Please wait for the response. If the connection times out, you can use the transaction ID to check the status later.

**Error Responses:**

**400 - Insufficient Balance:**
```json
{
    "success": false,
    "message": "Insufficient wallet balance",
    "data": {
        "required_amount": 25.00,
        "current_balance": 10.00,
        "shortage": 15.00
    }
}
```

**400 - Service Coming Soon:**
```json
{
    "success": false,
    "message": "This service is coming soon."
}
```

**400 - API Error:**
```json
{
    "success": false,
    "message": "Failed to verify Farmer ID. Please try again.",
    "data": {
        "status": 400,
        "message": "Invalid Aadhar number"
    }
}
```

**422 - Validation Error:**
```json
{
    "success": false,
    "message": "Validation error",
    "errors": {
        "aadhar": [
            "The aadhar must be 12 digits.",
            "The aadhar format is invalid."
        ]
    }
}
```

---

## Check Transaction Status

Check the status of a Farmer ID verification transaction. Useful if you want to check the status of a previous request or if the initial request timed out.

**Endpoint:** `GET /service/farmer-id/status/{id}`

**Headers:**
```
Authorization: Bearer {user_token}
```

**Parameters:**
- `id` (required): Transaction ID returned from the verify endpoint

**Success Response (200) - Pending:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "pending",
        "amount": 25.00,
        "service": {
            "id": 1,
            "name": "Farmer ID",
            "path": "/user/farmerid"
        },
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:00:00.000000Z"
    }
}
```

**Success Response (200) - Success:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "success",
        "amount": 25.00,
        "service": {
            "id": 1,
            "name": "Farmer ID",
            "path": "/user/farmerid"
        },
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:01:30.000000Z",
        "farmer_data": {
            "farmer_id": "45874742709",
            "farmer_aadhar_number": "576109808884",
            "farmer_dob": "1979-08-05",
            "farmer_name_en": "Bhausaheb Sakharam Dake",
            "farmer_name_local": "भाऊसाहेब सखाराम डाके",
            "farmer_gender": "Male",
            "farmer_pincode": 431130,
            "farmer_address": "Mhalas Pimpalgav",
            "farmer_mobile": "9445760262",
            "farmer_photograph": "/9j/4AAQSkZJRgABAgAAAQABAAD...",
            "farmer_land_ownerships": [
                {
                    "extentAssignedAreaInHectare": 1.99,
                    "villageName": "Mhalas Pimpalgaon",
                    "districtName": "BEED",
                    "subDistrictName": "Georai",
                    "surveyNumber": "75"
                }
            ]
        }
    }
}
```

**Success Response (200) - Failed:**
```json
{
    "success": true,
    "data": {
        "id": 1,
        "status": "failed",
        "amount": 25.00,
        "service": {
            "id": 1,
            "name": "Farmer ID",
            "path": "/user/farmerid"
        },
        "error_message": "Invalid Aadhar number",
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:01:30.000000Z"
    }
}
```

**Error Response (404):**
```json
{
    "success": false,
    "message": "Transaction not found"
}
```

---

## Service Transaction History

Get history of all service transactions for the authenticated user.

**Endpoint:** `GET /service/farmer-id/history`

**Headers:**
```
Authorization: Bearer {user_token}
```

**Query Parameters:**
- `page` (optional): Page number for pagination (default: 1)

**Success Response (200):**
```json
{
    "success": true,
    "data": {
        "current_page": 1,
        "data": [
            {
                "id": 1,
                "user_id": 1,
                "service_id": 1,
                "amount": 25.00,
                "service_type": "farmer_id",
                "request_data": {
                    "aadhar": "576109808884"
                },
                "response_data": {
                    "status": 200,
                    "data": {
                        "farmerID": "45874742709",
                        "farmerAadharNumber": "576109808884"
                    }
                },
                "status": "success",
                "error_message": null,
                "created_at": "2025-12-05T12:00:00.000000Z",
                "service": {
                    "id": 1,
                    "name": "Farmer ID",
                    "path": "/user/farmerid"
                }
            }
        ],
        "per_page": 20,
        "total": 1
    }
}
```

---

## Admin Service Management (with Cost)

### Add Service with Cost

**Endpoint:** `POST /api/admin/service`

**Request Body:**
```json
{
    "name": "Farmer ID",
    "path": "/user/farmerid",
    "is_coming_soon": false,
    "cost": 25.00
}
```

**Parameters:**
- `name` (required): Service name
- `path` (required): Service path (must start with `/`)
- `is_coming_soon` (optional): Boolean, default: false
- `cost` (optional): Decimal, service cost in rupees. Default: 0.00

**Success Response:**
```json
{
    "success": true,
    "message": "Service added successfully",
    "data": {
        "id": 1,
        "name": "Farmer ID",
        "path": "/user/farmerid",
        "is_coming_soon": false,
        "cost": 25.00,
        "created_by": 1,
        "created_at": "2025-12-05T12:00:00.000000Z",
        "updated_at": "2025-12-05T12:00:00.000000Z"
    }
}
```

### Update Service Cost

**Endpoint:** `PUT /api/admin/service/{id}`

**Request Body:**
```json
{
    "cost": 30.00
}
```

---

## Error Responses

### 401 Unauthorized
```json
{
    "success": false,
    "message": "Unauthorized. Please login first."
}
```

### 404 Service Not Found
```json
{
    "success": false,
    "message": "Farmer ID service not found. Please contact admin."
}
```

### 500 Server Error
```json
{
    "success": false,
    "message": "An error occurred while verifying Farmer ID. Please try again later.",
    "error": "Connection timeout"
}
```

---

## Testing Examples

### cURL Examples

**1. Verify Farmer ID:**
```bash
curl -X POST "https://api.alldigtalseva.com/api/service/farmer-id/verify" \
  -H "Authorization: Bearer {user_token}" \
  -H "Content-Type: application/json" \
  -d '{
    "aadhar": "576109808884"
  }'
```

**2. Check Transaction Status:**
```bash
curl -X GET "https://api.alldigtalseva.com/api/service/farmer-id/status/1" \
  -H "Authorization: Bearer {user_token}"
```

**3. Get Transaction History:**
```bash
curl -X GET "https://api.alldigtalseva.com/api/service/farmer-id/history" \
  -H "Authorization: Bearer {user_token}"
```

**4. Add Service with Cost (Admin):**
```bash
curl -X POST "https://api.alldigtalseva.com/api/admin/service" \
  -H "Authorization: Bearer {admin_token}" \
  -H "Content-Type: application/json" \
  -d '{
    "name": "Farmer ID",
    "path": "/user/farmerid",
    "is_coming_soon": false,
    "cost": 25.00
  }'
```

---

## Notes

1. **Response Time**: ⚠️ **Important**: The external API (`https://api.farmeridonline.com/api/farmer/verify_card_details`) typically takes 1-2 minutes to respond. The HTTP timeout is set to 3 minutes (180 seconds). Please keep the connection open and wait for the response. If your request times out, you can use the transaction ID to check the status later using the status endpoint.

2. **Service Cost**: The service cost is configurable by admin. If not set, it defaults to ₹25.00 for Farmer ID service.

3. **Wallet Deduction**: The amount is deducted from user's wallet only if:
   - User has sufficient balance
   - External API call is successful (status 200)
   - Farmer data is retrieved successfully

4. **Transaction Tracking**: All service usage is tracked in `service_transactions` table, including:
   - Request parameters
   - Response data
   - Status (success/failed/pending)
   - Error messages (if any)

5. **External API**: The service calls `https://api.farmeridonline.com/api/farmer/verify_card_details` with the Aadhar number as a query parameter. This API may take 1-2 minutes to process.

6. **Aadhar Validation**: Aadhar number must be exactly 12 digits and contain only numbers.

7. **Service Availability**: The service must exist in the database and must not be marked as "coming soon" for the API to work.

8. **Status Checking**: If your initial request times out or you want to check the status of a previous request, use the status endpoint with the transaction ID returned in the response.

---

## Database Schema

### services (updated)
- `id`: Primary key
- `name`: Service name
- `path`: Service path (unique)
- `is_coming_soon`: Boolean
- `cost`: Decimal (10,2) - Service cost in rupees
- `created_by`: Admin ID (foreign key)
- `timestamps`

### service_transactions
- `id`: Primary key
- `user_id`: User ID (foreign key)
- `service_id`: Service ID (foreign key)
- `amount`: Amount deducted
- `service_type`: Type of service (e.g., "farmer_id")
- `request_data`: JSON - Request parameters
- `response_data`: JSON - API response
- `status`: Enum (success, failed, pending)
- `error_message`: Text - Error details if failed
- `timestamps`

---

## Support

For issues or questions, please contact the development team.


