<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TrendingOffer;
use App\Models\Admin;

class TrendingOfferSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get or create an admin user
        $admin = Admin::first();
        if (!$admin) {
            $admin = Admin::create([
                'username' => 'admin',
                'email' => 'admin@alldigtalseva.com',
                'password' => 'admin123',
            ]);
        }

        $adminId = $admin->id;

        // Clear existing trending offers
        TrendingOffer::truncate();

        // Add trending offer texts for scrolling display
        TrendingOffer::create([
            'text' => '🎉 Special Offer: Get 50% off on all services this month! Use code SAVE50',
            'order' => 1,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '💰 New users get ₹100 welcome bonus on signup! Start your digital journey today',
            'order' => 2,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '📱 Refer your friends and earn ₹200 for each successful referral! Share the benefits',
            'order' => 3,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '⚡ Fast and secure document verification services available 24/7',
            'order' => 4,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🎁 Recharge your wallet and get 10% cashback! Limited time offer',
            'order' => 5,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '✅ Verify your Farmer ID and BOCW ID in just 2 minutes! Quick and easy',
            'order' => 6,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🔥 Limited Time: Flat ₹50 off on wallet recharge above ₹500! Use code FLAT50',
            'order' => 7,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🌟 Festival Special: Enjoy 20% discount + ₹50 cashback on all services!',
            'order' => 8,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '💳 Weekend Special: Get 15% off on all digital services this weekend only!',
            'order' => 9,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🚀 New Service Alert: BOCW ID verification now available! Verify in 2 minutes',
            'order' => 10,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🎯 Top up ₹1000 and get ₹150 bonus! Maximum savings on your recharge',
            'order' => 11,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '📞 Need Help? Our support team is available 24/7 to assist you',
            'order' => 12,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '🏆 Become a top referrer and earn up to ₹5000 per month! Start referring today',
            'order' => 13,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        TrendingOffer::create([
            'text' => '💎 Premium Services: Access exclusive features with our premium membership',
            'order' => 14,
            'is_active' => true,
            'created_by' => $adminId,
        ]);

        // Inactive offer (for testing)
        TrendingOffer::create([
            'text' => 'This is an inactive trending offer for testing purposes',
            'order' => 15,
            'is_active' => false,
            'created_by' => $adminId,
        ]);

        $this->command->info('Successfully seeded ' . TrendingOffer::count() . ' trending offers!');
        $this->command->info('Active trending offers: ' . TrendingOffer::where('is_active', true)->count());
    }
}
