<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Blog;
use App\Models\Admin;
use Carbon\Carbon;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get or create an admin user
        $admin = Admin::first();
        if (!$admin) {
            $admin = Admin::create([
                'username' => 'admin',
                'email' => 'admin@alldigtalseva.com',
                'password' => 'admin123',
            ]);
        }

        $adminId = $admin->id;
        $today = Carbon::today();
        $yesterday = Carbon::yesterday();
        $lastWeek = Carbon::today()->subWeek();

        // Clear existing blogs (optional - comment out if you want to keep existing data)
        // Blog::truncate();

        // Blog 1: How to Use Digital Seva Services
        Blog::create([
            'title' => 'How to Use Digital Seva Services - Complete Guide',
            'slug' => 'how-to-use-digital-seva-services-complete-guide',
            'excerpt' => 'Learn how to effectively use our digital services platform to access various government and private services online.',
            'content' => '<h2>Introduction to Digital Seva</h2>
<p>Digital Seva is your one-stop solution for accessing various digital services online. Whether you need to verify documents, access government services, or complete official paperwork, our platform makes it easy and convenient.</p>

<h2>Getting Started</h2>
<p>To begin using Digital Seva services, you need to:</p>
<ol>
<li>Create an account by signing up with your phone number</li>
<li>Verify your account using the OTP sent to your phone</li>
<li>Add money to your wallet for service payments</li>
<li>Browse available services and select the one you need</li>
</ol>

<h2>Available Services</h2>
<p>Our platform offers a wide range of services including:</p>
<ul>
<li>Farmer ID Verification</li>
<li>BOCW ID Verification</li>
<li>Document verification services</li>
<li>And many more...</li>
</ul>

<h2>Wallet Management</h2>
<p>You can top up your wallet using UPI payments. Simply request a top-up, make the payment, and wait for admin approval. Once approved, the amount will be credited to your wallet.</p>

<h2>Conclusion</h2>
<p>Digital Seva makes it easy to access essential services from the comfort of your home. Start using our platform today and experience the convenience of digital services.</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/4ECDC4/FFFFFF?text=How+to+Use+Digital+Seva',
            'meta_title' => 'How to Use Digital Seva Services - Complete Guide',
            'meta_description' => 'Learn how to use Digital Seva platform to access various digital services online. Complete guide with step-by-step instructions.',
            'is_published' => true,
            'published_at' => $today->toDateTimeString(),
            'views' => 250,
            'created_by' => $adminId,
        ]);

        // Blog 2: Understanding Farmer ID Verification
        Blog::create([
            'title' => 'Understanding Farmer ID Verification Process',
            'slug' => 'understanding-farmer-id-verification-process',
            'excerpt' => 'Everything you need to know about Farmer ID verification, including requirements, process, and benefits.',
            'content' => '<h2>What is Farmer ID?</h2>
<p>Farmer ID is a unique identification number issued to farmers in India. It helps in accessing various agricultural schemes and benefits provided by the government.</p>

<h2>Why Verify Your Farmer ID?</h2>
<p>Verifying your Farmer ID is essential for:</p>
<ul>
<li>Accessing government agricultural schemes</li>
<li>Receiving subsidies and benefits</li>
<li>Participating in farmer welfare programs</li>
<li>Getting agricultural loans</li>
</ul>

<h2>Verification Process</h2>
<p>The verification process is simple:</p>
<ol>
<li>Provide your Aadhar number</li>
<li>Our system will verify your details with the official database</li>
<li>You will receive your Farmer ID and related information</li>
<li>The process usually takes 1-2 minutes</li>
</ol>

<h2>Required Documents</h2>
<p>You only need your Aadhar number to verify your Farmer ID. Make sure your Aadhar is linked to your agricultural land records.</p>

<h2>Benefits</h2>
<p>Once verified, you can access various benefits and schemes available for farmers in your state.</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/95E1D3/FFFFFF?text=Farmer+ID+Verification',
            'meta_title' => 'Understanding Farmer ID Verification Process',
            'meta_description' => 'Complete guide on Farmer ID verification process, requirements, and benefits for farmers.',
            'is_published' => true,
            'published_at' => $yesterday->toDateTimeString(),
            'views' => 180,
            'created_by' => $adminId,
        ]);

        // Blog 3: BOCW ID Verification Guide
        Blog::create([
            'title' => 'BOCW ID Verification - Step by Step Guide',
            'slug' => 'bocw-id-verification-step-by-step-guide',
            'excerpt' => 'Learn how to verify your BOCW (Building and Other Construction Workers) ID and access worker benefits.',
            'content' => '<h2>What is BOCW ID?</h2>
<p>BOCW ID is a registration number for construction workers that enables them to access various welfare schemes and benefits provided by the government.</p>

<h2>Who Can Register?</h2>
<p>Any construction worker who:</p>
<ul>
<li>Is engaged in building or construction work</li>
<li>Has worked for at least 90 days in the last 12 months</li>
<li>Is between 18 and 60 years of age</li>
</ul>

<h2>Verification Process</h2>
<p>To verify your BOCW ID:</p>
<ol>
<li>Provide your Aadhar number</li>
<li>Our system will fetch your BOCW registration details</li>
<li>You will receive complete information including registration number, personal details, and photo</li>
</ol>

<h2>Benefits of BOCW Registration</h2>
<p>Registered workers can avail:</p>
<ul>
<li>Health insurance benefits</li>
<li>Educational assistance for children</li>
<li>Accident insurance</li>
<li>Pension schemes</li>
<li>Skill development programs</li>
</ul>

<h2>Important Information</h2>
<p>Make sure your Aadhar is linked to your BOCW registration for successful verification.</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/F38181/FFFFFF?text=BOCW+ID+Verification',
            'meta_title' => 'BOCW ID Verification - Step by Step Guide',
            'meta_description' => 'Complete guide on BOCW ID verification process for construction workers. Learn how to verify and access benefits.',
            'is_published' => true,
            'published_at' => $lastWeek->toDateTimeString(),
            'views' => 145,
            'created_by' => $adminId,
        ]);

        // Blog 4: Wallet Top-Up Guide
        Blog::create([
            'title' => 'How to Top Up Your Digital Seva Wallet',
            'slug' => 'how-to-top-up-your-digital-seva-wallet',
            'excerpt' => 'Learn how to add money to your Digital Seva wallet using UPI payments and start using services.',
            'content' => '<h2>Why Top Up Your Wallet?</h2>
<p>Your Digital Seva wallet is used to pay for various services on the platform. To use any service, you need sufficient balance in your wallet.</p>

<h2>Top-Up Process</h2>
<p>Follow these simple steps:</p>
<ol>
<li>Go to the Top-Up section in your account</li>
<li>Enter the amount you want to add</li>
<li>Select a UPI ID from the available list</li>
<li>Make the payment using your UPI app</li>
<li>Submit the payment screenshot</li>
<li>Wait for admin approval (usually within 24 hours)</li>
</ol>

<h2>Available UPI Options</h2>
<p>We support all major UPI apps including:</p>
<ul>
<li>Google Pay</li>
<li>PhonePe</li>
<li>Paytm</li>
<li>BHIM</li>
<li>And other UPI apps</li>
</ul>

<h2>Recharge Offers</h2>
<p>Check out our recharge offers to get discounts and cashback on your top-ups. Apply available offers during the top-up process.</p>

<h2>Minimum and Maximum Limits</h2>
<p>You can top up any amount starting from ₹100. There is no maximum limit, but larger amounts may require additional verification.</p>

<h2>Tracking Your Top-Up</h2>
<p>You can track the status of your top-up request in the "Top-Up Requests" section. You will be notified once it is approved.</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/AA96DA/FFFFFF?text=Wallet+Top-Up',
            'meta_title' => 'How to Top Up Your Digital Seva Wallet',
            'meta_description' => 'Complete guide on how to add money to your Digital Seva wallet using UPI payments.',
            'is_published' => true,
            'published_at' => $today->subDays(2)->toDateTimeString(),
            'views' => 320,
            'created_by' => $adminId,
        ]);

        // Blog 5: Referral Program Benefits
        Blog::create([
            'title' => 'Earn Money with Digital Seva Referral Program',
            'slug' => 'earn-money-with-digital-seva-referral-program',
            'excerpt' => 'Discover how you can earn money by referring friends and family to Digital Seva platform.',
            'content' => '<h2>What is the Referral Program?</h2>
<p>Our referral program allows you to earn money by inviting others to join Digital Seva. When someone signs up using your referral code, you earn commissions on their transactions.</p>

<h2>How It Works</h2>
<p>The referral system works on multiple levels:</p>
<ol>
<li>Share your unique referral code with friends and family</li>
<li>When they sign up using your code, they become your direct referral</li>
<li>You earn a commission on their wallet top-ups</li>
<li>You also earn on referrals made by your referrals (multi-level)</li>
</ol>

<h2>How to Get Your Referral Code</h2>
<p>Getting your referral code is easy:</p>
<ul>
<li>Log in to your Digital Seva account</li>
<li>Go to the Referral section</li>
<li>Copy your unique referral code</li>
<li>Share it with others</li>
</ul>

<h2>Earning Potential</h2>
<p>Your earnings depend on:</p>
<ul>
<li>Number of referrals you make</li>
<li>Activity level of your referrals</li>
<li>Commission rates set by the platform</li>
</ul>

<h2>Withdrawing Earnings</h2>
<p>Your referral earnings are credited to your wallet. You can use them for services or request a withdrawal (subject to terms and conditions).</p>

<h2>Tips for Success</h2>
<p>To maximize your earnings:</p>
<ul>
<li>Share your referral code on social media</li>
<li>Explain the benefits to potential users</li>
<li>Help your referrals get started</li>
<li>Stay active on the platform</li>
</ul>',
            'featured_image' => 'https://via.placeholder.com/1200x630/FCBAD3/FFFFFF?text=Referral+Program',
            'meta_title' => 'Earn Money with Digital Seva Referral Program',
            'meta_description' => 'Learn how to earn money by referring friends to Digital Seva. Complete guide on the referral program.',
            'is_published' => true,
            'published_at' => $today->subDays(3)->toDateTimeString(),
            'views' => 195,
            'created_by' => $adminId,
        ]);

        // Blog 6: Security and Privacy
        Blog::create([
            'title' => 'Security and Privacy on Digital Seva Platform',
            'slug' => 'security-and-privacy-on-digital-seva-platform',
            'excerpt' => 'Learn about the security measures and privacy policies that protect your data on Digital Seva.',
            'content' => '<h2>Your Data is Safe</h2>
<p>At Digital Seva, we take your security and privacy seriously. We implement industry-standard security measures to protect your personal information.</p>

<h2>Security Measures</h2>
<p>We use:</p>
<ul>
<li>Encrypted connections (HTTPS) for all data transmission</li>
<li>Secure authentication using OTP verification</li>
<li>Token-based API authentication</li>
<li>Regular security audits</li>
</ul>

<h2>Data Protection</h2>
<p>Your personal data is:</p>
<ul>
<li>Stored securely in encrypted databases</li>
<li>Never shared with third parties without consent</li>
<li>Used only for providing services</li>
<li>Protected by access controls</li>
</ul>

<h2>Payment Security</h2>
<p>All payment transactions are:</p>
<ul>
<li>Processed through secure UPI gateways</li>
<li>Verified by admin before approval</li>
<li>Recorded for audit purposes</li>
</ul>

<h2>Privacy Policy</h2>
<p>We respect your privacy and only collect data necessary for providing services. You can review our complete privacy policy in the app settings.</p>

<h2>Best Practices</h2>
<p>To keep your account secure:</p>
<ul>
<li>Never share your OTP with anyone</li>
<li>Use a strong password</li>
<li>Log out from shared devices</li>
<li>Report suspicious activity immediately</li>
</ul>',
            'featured_image' => 'https://via.placeholder.com/1200x630/FFD93D/FFFFFF?text=Security+Privacy',
            'meta_title' => 'Security and Privacy on Digital Seva Platform',
            'meta_description' => 'Learn about security measures and privacy policies that protect your data on Digital Seva platform.',
            'is_published' => true,
            'published_at' => $today->subDays(5)->toDateTimeString(),
            'views' => 165,
            'created_by' => $adminId,
        ]);

        // Blog 7: Benefits of Digital Services
        Blog::create([
            'title' => 'Benefits of Using Digital Services',
            'slug' => 'benefits-of-using-digital-services',
            'excerpt' => 'Discover the advantages of using digital services for your official and personal needs.',
            'content' => '<h2>Convenience</h2>
<p>Digital services allow you to complete tasks from anywhere, anytime. No need to visit offices or stand in long queues.</p>

<h2>Time Saving</h2>
<p>Complete tasks in minutes that would otherwise take hours or days. Access services 24/7 without waiting for office hours.</p>

<h2>Cost Effective</h2>
<p>Save money on travel, paperwork, and time. Digital services are often more affordable than traditional methods.</p>

<h2>Paperless</h2>
<p>Go paperless and contribute to environmental conservation. All documents are stored digitally.</p>

<h2>Secure</h2>
<p>Digital platforms use advanced security measures to protect your data and transactions.</p>

<h2>Transparent</h2>
<p>Track your requests and transactions in real-time. Get instant updates on the status of your applications.</p>

<h2>Accessible</h2>
<p>Access services from your smartphone or computer. No need for physical presence at offices.</p>

<h2>Conclusion</h2>
<p>Digital services are the future. Start using Digital Seva today and experience the benefits of going digital.</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/6BCB77/FFFFFF?text=Digital+Benefits',
            'meta_title' => 'Benefits of Using Digital Services',
            'meta_description' => 'Discover the advantages and benefits of using digital services for official and personal needs.',
            'is_published' => true,
            'published_at' => $today->subDays(7)->toDateTimeString(),
            'views' => 210,
            'created_by' => $adminId,
        ]);

        // Blog 8: Unpublished/Draft Blog (for testing)
        Blog::create([
            'title' => 'Upcoming Features - Coming Soon',
            'slug' => 'upcoming-features-coming-soon',
            'excerpt' => 'This is a draft blog post that is not yet published.',
            'content' => '<h2>New Features Coming</h2>
<p>We are working on exciting new features that will be available soon. Stay tuned for updates!</p>',
            'featured_image' => 'https://via.placeholder.com/1200x630/999999/FFFFFF?text=Coming+Soon',
            'meta_title' => 'Upcoming Features',
            'meta_description' => 'New features coming to Digital Seva platform.',
            'is_published' => false,
            'published_at' => null,
            'views' => 0,
            'created_by' => $adminId,
        ]);

        $this->command->info('Successfully seeded ' . Blog::count() . ' blogs!');
        $this->command->info('Published blogs: ' . Blog::where('is_published', true)->count());
        $this->command->info('Draft blogs: ' . Blog::where('is_published', false)->count());
    }
}
