<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReferralSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('referral_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('referral_levels')->default(3)->comment('Number of referral levels (e.g., 3 levels)');
            $table->json('level_commissions')->nullable()->comment('Commission rates per level as JSON: {"1": 10, "2": 5, "3": 2}');
            $table->enum('commission_type', ['percentage', 'fixed'])->default('percentage')->comment('Commission calculation type');
            $table->decimal('signup_bonus', 10, 2)->default(0.00)->comment('Bonus for referrer when someone signs up');
            $table->boolean('is_active')->default(true);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();
            
            $table->foreign('created_by')->references('id')->on('admins')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('referral_settings');
    }
}
