<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOfferFieldsToTopUpRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('top_up_requests', function (Blueprint $table) {
            $table->unsignedBigInteger('recharge_offer_id')->nullable()->after('upi_id');
            $table->decimal('discount_amount', 10, 2)->default(0.00)->after('amount');
            $table->decimal('cashback_amount', 10, 2)->default(0.00)->after('discount_amount');
            $table->decimal('final_credited_amount', 10, 2)->after('cashback_amount');
            
            $table->foreign('recharge_offer_id')->references('id')->on('recharge_offers')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('top_up_requests', function (Blueprint $table) {
            $table->dropForeign(['recharge_offer_id']);
            $table->dropColumn(['recharge_offer_id', 'discount_amount', 'cashback_amount', 'final_credited_amount']);
        });
    }
}
