<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Upi extends Model
{
    use HasFactory;

    protected $fillable = [
        'upi_id',
        'name',
        'status',
        'is_default',
        'created_by',
    ];

    protected $casts = [
        'is_default' => 'boolean',
    ];

    /**
     * Get the admin who created this UPI
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }
}
