<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrendingOffer extends Model
{
    use HasFactory;

    protected $fillable = [
        'text',
        'order',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'order' => 'integer',
    ];

    /**
     * Get the admin who created this trending offer
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }
}
