<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TopUpRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'upi_id',
        'recharge_offer_id',
        'amount',
        'discount_amount',
        'cashback_amount',
        'final_credited_amount',
        'status',
        'rejection_reason',
        'approved_by',
        'approved_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'cashback_amount' => 'decimal:2',
        'final_credited_amount' => 'decimal:2',
        'approved_at' => 'datetime',
    ];

    /**
     * Get the user who requested the top-up
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the UPI used for this request
     */
    public function upi()
    {
        return $this->belongsTo(Upi::class);
    }

    /**
     * Get the admin who approved/rejected the request
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'approved_by');
    }

    /**
     * Get the recharge offer applied to this request
     */
    public function rechargeOffer()
    {
        return $this->belongsTo(RechargeOffer::class, 'recharge_offer_id');
    }
}
