<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralEarning extends Model
{
    use HasFactory;

    protected $fillable = [
        'referrer_id',
        'referred_id',
        'level',
        'earning_type',
        'source_id',
        'source_type',
        'amount',
        'commission_amount',
        'status',
        'credited_at',
    ];

    protected $casts = [
        'level' => 'integer',
        'amount' => 'decimal:2',
        'commission_amount' => 'decimal:2',
        'credited_at' => 'datetime',
    ];

    /**
     * Get the referrer (user who earned)
     */
    public function referrer()
    {
        return $this->belongsTo(User::class, 'referrer_id');
    }

    /**
     * Get the referred user (user who generated earning)
     */
    public function referred()
    {
        return $this->belongsTo(User::class, 'referred_id');
    }

    /**
     * Get the source model (polymorphic)
     */
    public function source()
    {
        return $this->morphTo();
    }
}
