<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'image_url',
        'offer_type',
        'discount_percentage',
        'discount_amount',
        'cashback_amount',
        'promo_code',
        'valid_from',
        'valid_to',
        'link',
        'order',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'discount_percentage' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'cashback_amount' => 'decimal:2',
        'valid_from' => 'date',
        'valid_to' => 'date',
        'is_active' => 'boolean',
        'order' => 'integer',
    ];

    /**
     * Get the admin who created this offer
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }

    /**
     * Check if offer is currently valid
     */
    public function isValid()
    {
        $today = now()->toDateString();
        return $this->is_active 
            && $this->valid_from <= $today 
            && $this->valid_to >= $today;
    }
}
