<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gift extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'message',
        'is_read',
        'read_at',
        'created_by',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'is_read' => 'boolean',
        'read_at' => 'datetime',
    ];

    /**
     * Get the user who received the gift
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the admin who created the gift
     */
    public function admin()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }
}
