<?php

namespace App\Events;

use App\Models\TopUpRequest;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PaymentStatusUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $topUpRequest;
    public $status;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(TopUpRequest $topUpRequest, $status)
    {
        $this->topUpRequest = $topUpRequest;
        $this->status = $status;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new PrivateChannel('payment-status.' . $this->topUpRequest->user_id);
    }

    /**
     * The event's broadcast name.
     *
     * @return string
     */
    public function broadcastAs()
    {
        return 'payment.status.updated';
    }

    /**
     * Get the data to broadcast.
     *
     * @return array
     */
    public function broadcastWith()
    {
        return [
            'request_id' => $this->topUpRequest->id,
            'status' => $this->status,
            'amount' => $this->topUpRequest->amount,
            'final_credited_amount' => $this->topUpRequest->final_credited_amount,
            'user_id' => $this->topUpRequest->user_id,
            'updated_at' => $this->topUpRequest->updated_at,
        ];
    }
}
