# CSC User Authentication API

This document details the API endpoints for the CSC User Authentication system.

## Base URL
`https://api.alldigtalseva.com/api`

## Headers
| Header | Value | Description |
|---|---|---|
| `Accept` | `application/json` | Required for JSON responses |
| `Content-Type` | `application/json` | Required for sending JSON data |

---

## 1. CSC User Signup
Creates a new verified user account using CSC ID. No OTP verification is required.

- **Endpoint:** `/user/csc/signup`
- **Method:** `POST`

### Request Body
| Parameter | Type | Required | Description |
|---|---|---|---|
| `csc_id` | String | Yes | Unique CSC ID. |
| `password` | String | Yes | User's password (min 6 chars). **Stored as Plain Text**. |
| `phone_number` | String | Yes | Unique 10-digit phone number. |
| `state` | String | Yes | User's state (e.g., "Maharashtra"). |

**Example Request:**
```json
{
    "csc_id": "CSC12345",
    "password": "MySecretPassword",
    "phone_number": "9876543210",
    "state": "Maharashtra"
}
```

### Success Response (200 OK)
```json
{
    "success": true,
    "message": "Signup completed successfully",
    "data": {
        "id": 25,
        "csc_id": "CSC12345",
        "phone_number": "9876543210",
        "wallet_balance": "0.00",
        "token": "13|laravel_sanctum_token_string..."
    }
}
```

### Error Responses
- **422 Validation Error:** If `csc_id` or `phone_number` is already taken, or required fields are missing.

---

## 2. CSC User Login
Authenticates a user using CSC ID and Password.

- **Endpoint:** `/user/csc/login`
- **Method:** `POST`

### Request Body
| Parameter | Type | Required | Description |
|---|---|---|---|
| `csc_id` | String | Yes | Registered CSC ID. |
| `password` | String | Yes | User's password. |

**Example Request:**
```json
{
    "csc_id": "CSC12345",
    "password": "MySecretPassword"
}
```

### Success Response (200 OK)
```json
{
    "success": true,
    "message": "Login successful",
    "data": {
        "id": 25,
        "csc_id": "CSC12345",
        "phone_number": "9876543210",
        "wallet_balance": "0.00",
        "token": "14|laravel_sanctum_token_string..."
    }
}
```

### Error Responses
- **401 Unauthorized:** If `csc_id` does not exist or `password` does not match.


- **403 Forbidden:** If the user account is not verified (`is_verified = 0`).

---

## 3. Admin: Get CSC Users (Detailed)
Allows Admins to view all CSC Users, including their **Plain Text Passwords**, **State**, and **Verification Status**.

- **Endpoint:** `/admin/user/csc-users`
- **Method:** `GET`
- **Headers:** `Authorization: Bearer <ADMIN_TOKEN>`

### Query Parameters
| Parameter | Type | Required | Description |
|---|---|---|---|
| `search` | String | No | Search by CSC ID, Name, Phone, or State. |
| `state` | String | No | Filter by State. |
| `per_page` | Integer | No | Users per page (default: 15). |

### Success Response (200 OK)
```json
{
    "success": true,
    "data": [
        {
            "id": 25,
            "name": null,
            "email": null,
            "phone_number": "9876543210",
            "csc_id": "CSC12345",
            "state": "Maharashtra",
            "password": "MySecretPassword", // Visible here
            "wallet_balance": "0.00",
            "is_verified": 1, // 1 = Verified, 0 = Unverified
            "created_at": "2026-01-15T12:00:00.000000Z"
        }
    ],
    "pagination": { ... }
}
```

---

## 4. Admin: Update CSC User
Allows Admins to update user details including **Verification Status**, **Plain Text Password**, **CSC ID**, and **State**.

- **Endpoint:** `/admin/user/{id}`
- **Method:** `PUT` or `POST`
- **Headers:** `Authorization: Bearer <ADMIN_TOKEN>`

### Request Body
| Parameter | Type | Required | Description |
|---|---|---|---|
| `csc_id` | String | No | Update CSC ID (Must be unique). |
| `state` | String | No | Update State. |
| `password` | String | No | Update Password (Stores as Plain Text). |
| `is_verified` | Boolean | No | `1` (True) or `0` (False). |
| `phone_number` | String | No | Update Phone Number. |
| `wallet_balance`| Decimal| No | Update Wallet Balance. |

### Success Response (200 OK)
```json
{
    "success": true,
    "message": "User updated successfully",
    "data": {
        "id": 25,
        "csc_id": "NEW_CSC_ID",
        "state": "Updated State",
        "is_verified": 1,
        ...
    }
}
```

---

## 5. Admin: State URL Management
Manage mappings between **States** and **Target URLs** based on URL patterns.

- **Base Endpoint:** `/admin/state-urls`
- **Headers:** `Authorization: Bearer <ADMIN_TOKEN>`

### 5.1 Create Configuration
- **Method:** `POST /admin/state-urls`
- **Body:**
```json
{
    "state_name": "Maharashtra",
    "url": "https://mhfr.agristack.gov.in/farmer-registry-mh/",
    "api_url": "https://mhfr.agristack.gov.in/farmer-registry-api-mh/agristack/v1/api/farmerRegistry/getFarmerDataByAadhaar",
    "includes_pattern": "mhfr.agristack.gov.in",
    "username": "user123",
    "password": "password123"
}
```

### 5.2 List Configurations
- **Method:** `GET /admin/state-urls`

### 5.3 Update Configuration
- **Method:** `PUT /admin/state-urls/{id}`
- **Body:** (Any of the fields from Create)

### 5.4 Delete Configuration
- **Method:** `DELETE /admin/state-urls/{id}`

---

## 6. Automation IDs
Endpoints designed for the Node.js automation script.

### 6.1 Fetch Configuration
Get URL, Pattern, and Credentials by **State Name**.
- **Method:** `GET /admin/state-urls/fetch-config`
- **Query Param:** `state_name` (e.g., `?state_name=Maharashtra`)
- **Response:**
```json
{
    "success": true,
    "data": {
        "state_name": "Maharashtra",
        "url": "https://mhfr.agristack.gov.in/farmer-registry-mh/",
        "api_url": "https://mhfr.agristack.gov.in/farmer-registry-api-mh/agristack/v1/api/farmerRegistry/getFarmerDataByAadhaar",
        "includes_pattern": "mhfr.agristack.gov.in",
        "username": "user123",
        "password": "password123",
        "token": "EXISTING_TOKEN"
    }
}
```

### 6.2 Update Token & Credentials
Update the token (and optionally credentials) by **State Name**.
- **Method:** `POST /admin/state-urls/update-token`
- **Body:**
```json
{
    "state_name": "Maharashtra",
    "token": "NEW_GENERATED_TOKEN",
    "username": "OPTIONAL_UPDATE",
    "password": "OPTIONAL_UPDATE",
    "api_url": "OPTIONAL_UPDATE"
}
```

---

## 7. Automation Server API (Node.js)
This API runs on the separate Node.js server (default port 3000).

### 7.1 Verify Farmer Card Details
Fetches farmer details using the configured State API and handles automatic token refreshing.
- **Method:** `GET /verify_card_details`
- **Query Params:**
    - `state_name`: Name of the state (must match backend configuration)
    - `aadhar`: Farmer's Aadhaar number
- **Example:** `GET http://localhost:3000/verify_card_details?state_name=Maharashtra&aadhar=123456789012`
- **Response:**
```json
{
    "status": 200,
    "http_code": 200,
    "data": {
        "farmerID": "...",
        "farmerAadharNumber": "...",
        "farmerDob": "...",
        "farmerNameEn": "...",
        "farmerLandOwnerShips": [...]
    }
}
```
